SuperStrict

Framework wx.wxApp
Import wx.wxGLCanvas
Import wx.wxglmax2d
Import wx.wxTimer
Import "GLCanvasTest.bmx"
Import rigz.timelinefx
Import rigz.tweener


New MyApp.run()


Type MyApp Extends wxApp

	Field frame:tGLCanvasWindow

	Method OnInit:Int()

		' Create the main application windowType MyFrame Extends wxFrame

		frame = tGLCanvasWindow(New tGLCanvasWindow.Create(,, "",, , 640, 480))
		
		' Show it and tell the application that it's our main window
		frame.show(True)
		SetTopWindow(frame)

		Return True
	End Method

End Type

Type tGLCanvasWindow Extends GraphicsWindowBase
	
	Field canvas:tCanvas

	Method OnInit()
	
		Super.oninit()
		
		canvas = tCanvas(New tCanvas.Create(Self, -1, GRAPHICS_BACKBUFFER | GRAPHICS_DEPTHBUFFER))
		szr_canvas.Add(canvas, 1, wxEXPAND)
	
		ConnectAny(wxEVT_CLOSE, OnClose)
		
	End Method
	
	Function OnClose(event:wxEvent)
		tGLCanvasWindow(event.parent).canvas.timer.Stop()
		event.Skip()
	End Function


End Type

Type tCanvas Extends wxGLCanvas

	Field timer:wxTimer
	Field tweener:tTweener
	Field effect:tlEffect
	Field effectlib:tlEffectsLibrary
	Field pm:tlParticleManager

	Method OnInit()
		SetBackgroundStyle(wxBG_STYLE_CUSTOM)
	
		timer = New wxTimer.Create(Self)
		tweener = New tTweener.Create(30)
		
		effectlib = LoadEffects("AreaEffect.eff")
		pm = CreateParticleManager()
		pm.SetScreenSize(640, 480)
		effect = CopyEffect(effectlib.GetEffect("area test"), pm)
		pm.addeffect(effect)
		
		ConnectAny(wxEVT_TIMER, OnTick)
		Connect(wxID_ANY, wxEVT_IDLE, onIdle)

		timer.Start(1)
		
	End Method

	Method OnPaint(event:wxPaintEvent)
		Local w:Int, h:Int
		tCanvas(event.parent).GetSize(w, h)
		SetGraphics (CanvasGraphics2D(Self))
		SetVirtualResolution(w, h)
		SetViewport(0, 0, w, h)
		Render()
	End Method

	Method Render()
		Local win:tGLCanvasWindow = tGLCanvasWindow(GetParent())
		
		Cls

		Tweener.Update()
	
		For Local Ticks:Int = 1 To Tweener.FrameTicks
			Tweener.UpdateExecutionTime()
			pm.Update()
		Next

		pm.DrawParticles(tweener.getTween())
		DrawText tweener.getfps(),10,10
		
		'Comment out each one for differenct results
		'win.fps_bar.SetStatusText("Test")
		'win.fps_bar.SetStatusText(MilliSecs())
		'win.fps_bar.SetStatusText(tweener.getfps())
				
		Flip 0

	End Method

	Function OnTick(event:wxEvent)
		wxWindow(event.parent).Refresh()
	End Function
	
	Function OnIdle(event:wxEvent)
		wxWindow(event.parent).Refresh()
		wxIdleEvent(event).RequestMore()
	End Function
	

End Type